import { world, system } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:jade_dagger', {
        onHitEntity({ attackingEntity }) {
            const selectedItem = attackingEntity.getComponent('equippable').getEquipment('Mainhand')
            const { x, y, z } = attackingEntity.getHeadLocation()
            if (attackingEntity && selectedItem?.typeId === 'v360:jade_dagger') {
                const spwanLoc = { x: x, y: y + 1, z: z }
                const viewDir = attackingEntity.getViewDirection()
                const jadeDagger = attackingEntity.dimension.spawnEntity("v360:jade_dagger", spwanLoc)
                const projectile = jadeDagger.getComponent("projectile")
                projectile.owner = attackingEntity
                projectile.shoot(viewDir)
            }
        }
    })
})

world.afterEvents.entityHitEntity.subscribe((data) => {
    const player = data.hitEntity
    const { x, y, z } = player.getHeadLocation()
    if (player.hasComponent('equippable') && player.getComponent('equippable').getEquipment('Mainhand').typeId === 'v360:jade_dagger') {
        const spwanLoc = { x: x, y: y + 1, z: z }
        const viewDir = player.getViewDirection()
        const jadeDagger = player.dimension.spawnEntity("v360:jade_dagger", spwanLoc)
        const projectile = jadeDagger.getComponent("projectile")
        projectile.owner = player
        projectile.shoot(viewDir)
    }
})

world.afterEvents.projectileHitEntity.subscribe((data) => {
    const projectile = data.projectile
    const shooter = data.source
    const { x, y, z } = shooter.location
    const target = data.getEntityHit()
    const targLoc = target.entity.location
    const chance = Math.random()
    if (projectile.typeId === 'v360:jade_dagger') {
        if (chance < 0.20) {
            shooter.teleport({ x: targLoc.x, y: targLoc.y, z: targLoc.z })
            shooter.dimension.playSound('mob.breeze.slide', shooter.location)
            shooter.dimension.spawnParticle('v360:jade_dagger', { x: x, y: y + 0.5, z: z }
            )
            target.entity.applyImpulse({ x: 0, y: 0.7, z: 0 })
            target.entity.dimension.playSound('wind_charge.burst', targLoc)
            target.entity.dimension.spawnParticle('v360:jade_dagger', targLoc)
        }
        else { }
    }
})